<?php
include 'koneksi.php';
session_start();

// Cek apakah user sudah login
if (!isset($_SESSION['status']) || $_SESSION['status'] !== "login") {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

// Cek apakah ada action
if (!isset($_POST['action'])) {
    echo json_encode(['success' => false, 'message' => 'No action specified']);
    exit();
}

$action = $_POST['action'];
$role = $_SESSION['role'];

// Proses Baca Satu Notifikasi
if ($action == 'baca_satu') {
    if (!isset($_POST['id_notif'])) {
        echo json_encode(['success' => false, 'message' => 'ID notifikasi tidak ditemukan']);
        exit();
    }
    
    $id_notif = mysqli_real_escape_string($conn, $_POST['id_notif']);
    
    // Update status notifikasi menjadi DIBACA
    $query = "UPDATE notifikasi 
              SET status = 'DIBACA' 
              WHERE id_notif = '$id_notif' AND role = '$role'";
    
    $result = mysqli_query($conn, $query);
    
    if ($result) {
        echo json_encode(['success' => true, 'message' => 'Notifikasi telah dibaca']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Gagal mengupdate notifikasi']);
    }
}

// Proses Baca Semua Notifikasi
elseif ($action == 'baca_semua') {
    // Update semua notifikasi yang statusnya BARU menjadi DIBACA
    $query = "UPDATE notifikasi 
              SET status = 'DIBACA' 
              WHERE role = '$role' AND status = 'BARU'";
    
    $result = mysqli_query($conn, $query);
    
    if ($result) {
        $jumlah_updated = mysqli_affected_rows($conn);
        echo json_encode([
            'success' => true, 
            'message' => 'Semua notifikasi telah dibaca',
            'jumlah' => $jumlah_updated
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Gagal mengupdate notifikasi']);
    }
}

// Action tidak dikenali
else {
    echo json_encode(['success' => false, 'message' => 'Invalid action']);
}

mysqli_close($conn);
?>